-- phpMyAdmin SQL Dump
-- version 4.4.14
-- http://www.phpmyadmin.net
--
-- Servidor: 127.0.0.1
-- Tiempo de generación: 14-06-2016 a las 16:14:28
-- Versión del servidor: 5.6.26
-- Versión de PHP: 5.6.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `portafolio`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `aplicaciones`
--

CREATE TABLE IF NOT EXISTS `aplicaciones` (
  `aplicacion` varchar(40) NOT NULL,
  `estado_aplicacion` int(3) NOT NULL,
  `fecha` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `areas`
--

CREATE TABLE IF NOT EXISTS `areas` (
  `id_area` int(3) NOT NULL,
  `nombre_areas` varchar(40) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `areas`
--

INSERT INTO `areas` (`id_area`, `nombre_areas`) VALUES
(1, 'Talento Humano'),
(2, 'Financiero'),
(3, 'Compras'),
(4, 'Almacen'),
(5, 'Tesoreria'),
(6, 'Mantenimiento'),
(7, 'Administracion'),
(8, 'Seguridad'),
(9, 'Comercial'),
(10, 'Tecnologia'),
(11, 'Mantenimiento'),
(12, 'Contabilidad');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacioimpresora`
--

CREATE TABLE IF NOT EXISTS `asignacioimpresora` (
  `cedula` varchar(12) NOT NULL,
  `serial_impresora` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacioncamara`
--

CREATE TABLE IF NOT EXISTS `asignacioncamara` (
  `cedula` varchar(12) NOT NULL,
  `serial_camara` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacioncpu`
--

CREATE TABLE IF NOT EXISTS `asignacioncpu` (
  `cedula` varchar(12) NOT NULL,
  `serial_cpu` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacionequipos`
--

CREATE TABLE IF NOT EXISTS `asignacionequipos` (
  `codigo` int(3) NOT NULL,
  `cedula` varchar(12) DEFAULT NULL,
  `serial_equipo` varchar(40) NOT NULL,
  `equipo` int(3) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacionmouse`
--

CREATE TABLE IF NOT EXISTS `asignacionmouse` (
  `cedula` varchar(12) NOT NULL,
  `serial_mouse` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacionpantalla`
--

CREATE TABLE IF NOT EXISTS `asignacionpantalla` (
  `cedula` varchar(12) NOT NULL,
  `serial_pantalla` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacionportatil`
--

CREATE TABLE IF NOT EXISTS `asignacionportatil` (
  `cedula` varchar(12) NOT NULL,
  `serial_portatil` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignaciontablets`
--

CREATE TABLE IF NOT EXISTS `asignaciontablets` (
  `cedula` varchar(12) NOT NULL,
  `serial_tablets` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacionteclado`
--

CREATE TABLE IF NOT EXISTS `asignacionteclado` (
  `cedula` varchar(12) NOT NULL,
  `serial_teclado` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(150) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asignacion_aplicacion`
--

CREATE TABLE IF NOT EXISTS `asignacion_aplicacion` (
  `cedula` varchar(12) NOT NULL,
  `aplicacion` varchar(40) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `observacion` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `camara`
--

CREATE TABLE IF NOT EXISTS `camara` (
  `codigo` int(3) NOT NULL,
  `serial_camara` varchar(40) NOT NULL,
  `estado_camara` int(3) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cpu`
--

CREATE TABLE IF NOT EXISTS `cpu` (
  `codigo` int(3) NOT NULL,
  `serial_cpu` varchar(40) NOT NULL,
  `marca_cpu` int(3) NOT NULL,
  `memoria` int(3) NOT NULL,
  `procesador` int(3) NOT NULL,
  `sistema_operativo` int(3) NOT NULL,
  `disco_duro` int(3) NOT NULL,
  `nombre_equipo` varchar(40) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `estado_cpu` int(3) NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `disco_duro`
--

CREATE TABLE IF NOT EXISTS `disco_duro` (
  `id_discoduro` int(3) NOT NULL,
  `nombre_discoduro` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `disco_duro`
--

INSERT INTO `disco_duro` (`id_discoduro`, `nombre_discoduro`) VALUES
(1, '40 GB'),
(2, '70 GB'),
(3, '100 GB'),
(4, '150 GB'),
(5, '200 GB'),
(6, '250 GB'),
(7, '300 GB'),
(8, '350 GB'),
(9, '400 GB'),
(10, '450 GB'),
(11, '500 GB'),
(12, '550 GB'),
(13, '600 GB'),
(14, '650 GB'),
(15, '700 GB'),
(16, '750 GB'),
(17, '800 GB'),
(18, '950 GB'),
(19, '1 TB');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `equipo`
--

CREATE TABLE IF NOT EXISTS `equipo` (
  `id_equipo` int(3) NOT NULL,
  `nombre_equipo` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `equipo`
--

INSERT INTO `equipo` (`id_equipo`, `nombre_equipo`) VALUES
(1, 'Portatil'),
(2, 'CPU'),
(3, 'Pantalla'),
(4, 'Teclado'),
(5, 'Mouse'),
(6, 'Impresora'),
(7, 'Tablets'),
(8, 'Camara');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `estado_equipo`
--

CREATE TABLE IF NOT EXISTS `estado_equipo` (
  `id_estadoequipo` int(3) NOT NULL,
  `nombre_estadoequipo` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `estado_equipo`
--

INSERT INTO `estado_equipo` (`id_estadoequipo`, `nombre_estadoequipo`) VALUES
(1, ' Produccion'),
(2, 'Disponible'),
(3, 'Destruido'),
(4, 'Reparacion'),
(5, 'Vigentes'),
(6, 'No Vigente');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `estado_persona`
--

CREATE TABLE IF NOT EXISTS `estado_persona` (
  `id_estadopersona` int(3) NOT NULL,
  `nombre_estadopersona` varchar(40) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `estado_persona`
--

INSERT INTO `estado_persona` (`id_estadopersona`, `nombre_estadopersona`) VALUES
(1, 'Activo'),
(2, 'Inactivo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_camara`
--

CREATE TABLE IF NOT EXISTS `historial_camara` (
  `codigo` int(3) NOT NULL,
  `serial_camara` varchar(40) NOT NULL,
  `estado_camara` varchar(40) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_cpu`
--

CREATE TABLE IF NOT EXISTS `historial_cpu` (
  `codigo` int(3) NOT NULL,
  `serial_cpu` varchar(40) NOT NULL,
  `marca_cpu` int(3) DEFAULT NULL,
  `memoria` int(3) DEFAULT NULL,
  `procesador` int(3) DEFAULT NULL,
  `sistema_operativo` int(3) DEFAULT NULL,
  `disco_duro` int(3) DEFAULT NULL,
  `nombre_equipo` varchar(40) DEFAULT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `estado_equipo` int(3) DEFAULT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_impresora`
--

CREATE TABLE IF NOT EXISTS `historial_impresora` (
  `codigo` int(3) NOT NULL,
  `serial_impresora` varchar(40) NOT NULL,
  `marca_impresora` varchar(40) DEFAULT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `estado_impresora` int(3) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_mouse`
--

CREATE TABLE IF NOT EXISTS `historial_mouse` (
  `codigo` int(3) NOT NULL,
  `serial_mouse` varchar(40) NOT NULL,
  `estado_mouse` int(3) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_pantalla`
--

CREATE TABLE IF NOT EXISTS `historial_pantalla` (
  `codigo` int(3) NOT NULL,
  `serial_pantalla` varchar(40) NOT NULL,
  `marca_pantalla` int(3) DEFAULT NULL,
  `estado_pantalla` int(3) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_portatil`
--

CREATE TABLE IF NOT EXISTS `historial_portatil` (
  `codigo` int(3) NOT NULL,
  `serial_portatil` varchar(40) NOT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `marca_portatil` int(3) DEFAULT NULL,
  `estado_portatil` int(3) DEFAULT NULL,
  `memoria` int(3) DEFAULT NULL,
  `procesador` int(3) DEFAULT NULL,
  `sistema_operativo` int(3) DEFAULT NULL,
  `disco_duro` int(3) DEFAULT NULL,
  `nombre_equipo` varchar(20) DEFAULT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_tablets`
--

CREATE TABLE IF NOT EXISTS `historial_tablets` (
  `codigo` int(3) NOT NULL,
  `serial_tablets` varchar(40) NOT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `estado_tablets` int(3) NOT NULL,
  `marca_tablets` int(3) DEFAULT NULL,
  `procesador` int(3) DEFAULT NULL,
  `sistema_operativo` int(3) DEFAULT NULL,
  `memoria` int(3) DEFAULT NULL,
  `cargador_serial` varchar(40) DEFAULT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `historial_teclado`
--

CREATE TABLE IF NOT EXISTS `historial_teclado` (
  `codigo` int(3) NOT NULL,
  `serial_teclado` varchar(40) NOT NULL,
  `estado_teclado` int(3) DEFAULT NULL,
  `fecha_historial` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `observacion` varchar(300) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `impresoras`
--

CREATE TABLE IF NOT EXISTS `impresoras` (
  `codigo` int(3) NOT NULL,
  `serial_impresora` varchar(40) NOT NULL,
  `marca_impresora` varchar(40) NOT NULL,
  `ip` varchar(40) DEFAULT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `estado_impresora` int(3) NOT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `marca_cpu`
--

CREATE TABLE IF NOT EXISTS `marca_cpu` (
  `id_marcacpu` int(3) NOT NULL,
  `nombre_marcacpu` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `marca_cpu`
--

INSERT INTO `marca_cpu` (`id_marcacpu`, `nombre_marcacpu`) VALUES
(1, 'JANUS'),
(2, 'HP'),
(3, 'ARGON'),
(4, 'EASY');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `marca_pantalla`
--

CREATE TABLE IF NOT EXISTS `marca_pantalla` (
  `id_marcapantalla` int(3) NOT NULL,
  `nombre_marcapantalla` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `marca_pantalla`
--

INSERT INTO `marca_pantalla` (`id_marcapantalla`, `nombre_marcapantalla`) VALUES
(1, 'LG'),
(2, 'SANSUNG'),
(3, 'HP');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `marca_portatil`
--

CREATE TABLE IF NOT EXISTS `marca_portatil` (
  `id_marcaportatil` int(3) NOT NULL,
  `nombre_marcaportatil` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `marca_portatil`
--

INSERT INTO `marca_portatil` (`id_marcaportatil`, `nombre_marcaportatil`) VALUES
(1, 'DELL'),
(2, 'ASUS'),
(3, 'HP'),
(4, 'TOSHIBA'),
(5, 'ACER');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `marca_tablets`
--

CREATE TABLE IF NOT EXISTS `marca_tablets` (
  `id_marcatablets` int(3) NOT NULL,
  `nombre_marcatablets` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `marca_tablets`
--

INSERT INTO `marca_tablets` (`id_marcatablets`, `nombre_marcatablets`) VALUES
(1, 'HP'),
(2, 'ASUS'),
(3, 'ACER');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `memoria`
--

CREATE TABLE IF NOT EXISTS `memoria` (
  `id_memoria` int(3) NOT NULL,
  `nombre_memoria` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `memoria`
--

INSERT INTO `memoria` (`id_memoria`, `nombre_memoria`) VALUES
(1, '512 MG'),
(2, '1 GB'),
(3, '2 GB'),
(4, '3 GB'),
(5, '4 GB'),
(6, '5 GB'),
(7, '6 GB'),
(8, '7 GB'),
(9, '8 GB'),
(10, '9 GB'),
(11, '10 GB'),
(12, '11 GB'),
(13, '12 GB'),
(14, '13 GB'),
(15, '14 GB'),
(16, '15 GB'),
(17, '16 GB');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `mouse`
--

CREATE TABLE IF NOT EXISTS `mouse` (
  `codigo` int(3) NOT NULL,
  `serial_mouse` varchar(40) NOT NULL,
  `estado_mouse` int(3) NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `pantalla`
--

CREATE TABLE IF NOT EXISTS `pantalla` (
  `codigo` int(3) NOT NULL,
  `serial_pantalla` varchar(40) NOT NULL,
  `marca_pantalla` int(3) NOT NULL,
  `estado_pantalla` int(3) NOT NULL,
  `fecha_ingreso` datetime NOT NULL,
  `usuario` varchar(16) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `portatil`
--

CREATE TABLE IF NOT EXISTS `portatil` (
  `serial_portatil` varchar(40) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `estado_portatil` int(3) NOT NULL,
  `marca_portatil` int(3) NOT NULL,
  `memoria` int(3) NOT NULL,
  `procesador` int(3) NOT NULL,
  `sistema_operativo` int(3) NOT NULL,
  `disco_duro` int(3) NOT NULL,
  `nombre_equipo` varchar(20) NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `procesador`
--

CREATE TABLE IF NOT EXISTS `procesador` (
  `id_procesador` int(3) NOT NULL,
  `nombre_procesador` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `procesador`
--

INSERT INTO `procesador` (`id_procesador`, `nombre_procesador`) VALUES
(1, 'intel dual core'),
(2, 'intel core 3'),
(3, 'intel core 5'),
(4, 'intel core7'),
(5, 'quad core');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `registro_persona`
--

CREATE TABLE IF NOT EXISTS `registro_persona` (
  `codigo` int(3) NOT NULL,
  `cedula` varchar(12) NOT NULL,
  `nombre` varchar(20) NOT NULL,
  `apellido` varchar(20) NOT NULL,
  `celular` varchar(11) DEFAULT NULL,
  `Telefonofijo` varchar(11) DEFAULT NULL,
  `correo` varchar(60) DEFAULT NULL,
  `sede` int(3) DEFAULT NULL,
  `area` int(3) DEFAULT NULL,
  `estado_persona` int(3) DEFAULT NULL,
  `fecha_ingreso` datetime DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rol`
--

CREATE TABLE IF NOT EXISTS `rol` (
  `id_rol` int(3) NOT NULL,
  `nombre_rol` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `sedes`
--

CREATE TABLE IF NOT EXISTS `sedes` (
  `id_sede` int(3) NOT NULL,
  `nombre_sede` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `sedes`
--

INSERT INTO `sedes` (`id_sede`, `nombre_sede`) VALUES
(1, 'Bogota'),
(2, 'Barrancabermeja'),
(3, 'Bucaramanga'),
(4, 'Duitama'),
(5, 'Barranquilla'),
(6, 'Ronal Castro'),
(7, 'Cali'),
(8, 'Buenaventura'),
(9, 'racevedo'),
(10, 'Cucuta'),
(11, 'Cartagena'),
(12, 'Santa Marta'),
(13, 'Villavicencio'),
(14, 'Medellín'),
(15, 'Buga'),
(16, 'Manizales'),
(17, 'Diaco Tocancipa'),
(18, 'Medellín-Procter'),
(19, 'BARRANCA DE UPÌA'),
(20, 'Puerto Gaitan'),
(21, 'Cedi Pereira'),
(22, 'Cali-Colgate'),
(23, 'Muña'),
(24, 'CediMontevideocroosdocking'),
(25, 'Cedimedellin'),
(26, 'Cedibuenaventura'),
(27, 'achroma'),
(28, 'Basf Quimica'),
(29, 'Indumil'),
(30, 'Tactic'),
(31, 'Casa Luker'),
(32, 'CediCali');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `sistema_operativo`
--

CREATE TABLE IF NOT EXISTS `sistema_operativo` (
  `id_sistemaoperativo` int(3) NOT NULL,
  `nombre_sistemaoperativo` varchar(40) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Volcado de datos para la tabla `sistema_operativo`
--

INSERT INTO `sistema_operativo` (`id_sistemaoperativo`, `nombre_sistemaoperativo`) VALUES
(1, 'XP'),
(2, 'Windows 7'),
(3, 'WINDOWS 8'),
(4, 'WINDOWS 8.1'),
(5, 'WINDOWS 10');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tablets`
--

CREATE TABLE IF NOT EXISTS `tablets` (
  `codigo` int(3) NOT NULL,
  `serial_tablets` varchar(40) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `estado_tablets` int(3) NOT NULL,
  `marca_tablets` int(3) NOT NULL,
  `procesador` int(3) NOT NULL,
  `sistema_operativo` int(3) NOT NULL,
  `cargador_serial` varchar(40) NOT NULL,
  `memoria` int(3) NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `teclado`
--

CREATE TABLE IF NOT EXISTS `teclado` (
  `codigo` int(3) NOT NULL,
  `serial_teclado` varchar(40) NOT NULL,
  `estado_teclado` int(3) NOT NULL,
  `usuario` varchar(16) DEFAULT NULL,
  `fecha_ingreso` datetime NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE IF NOT EXISTS `usuarios` (
  `nombre` varchar(20) NOT NULL,
  `apellido` varchar(20) NOT NULL,
  `cedula` varchar(12) NOT NULL,
  `usuario` varchar(20) NOT NULL,
  `password` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Índices para tablas volcadas
--

--
-- Indices de la tabla `aplicaciones`
--
ALTER TABLE `aplicaciones`
  ADD PRIMARY KEY (`aplicacion`),
  ADD KEY `estado_aplicacion` (`estado_aplicacion`);

--
-- Indices de la tabla `areas`
--
ALTER TABLE `areas`
  ADD PRIMARY KEY (`id_area`);

--
-- Indices de la tabla `asignacioimpresora`
--
ALTER TABLE `asignacioimpresora`
  ADD PRIMARY KEY (`serial_impresora`),
  ADD KEY `cedula` (`cedula`,`serial_impresora`,`usuario`),
  ADD KEY `serial_impresora` (`serial_impresora`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacioncamara`
--
ALTER TABLE `asignacioncamara`
  ADD PRIMARY KEY (`serial_camara`),
  ADD KEY `cedula` (`cedula`,`serial_camara`,`usuario`),
  ADD KEY `serial_camara` (`serial_camara`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacioncpu`
--
ALTER TABLE `asignacioncpu`
  ADD PRIMARY KEY (`serial_cpu`),
  ADD KEY `cedula` (`cedula`,`serial_cpu`),
  ADD KEY `serial_cpu` (`serial_cpu`);

--
-- Indices de la tabla `asignacionequipos`
--
ALTER TABLE `asignacionequipos`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `cedula` (`cedula`);

--
-- Indices de la tabla `asignacionmouse`
--
ALTER TABLE `asignacionmouse`
  ADD PRIMARY KEY (`serial_mouse`),
  ADD KEY `cedula` (`cedula`,`serial_mouse`,`usuario`),
  ADD KEY `serial_mouse` (`serial_mouse`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacionpantalla`
--
ALTER TABLE `asignacionpantalla`
  ADD PRIMARY KEY (`serial_pantalla`),
  ADD KEY `cedula` (`cedula`,`serial_pantalla`,`usuario`),
  ADD KEY `serial_pantalla` (`serial_pantalla`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacionportatil`
--
ALTER TABLE `asignacionportatil`
  ADD PRIMARY KEY (`serial_portatil`),
  ADD KEY `cedula` (`cedula`,`serial_portatil`,`usuario`),
  ADD KEY `serial_portatil` (`serial_portatil`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `serial_portatil_2` (`serial_portatil`);

--
-- Indices de la tabla `asignaciontablets`
--
ALTER TABLE `asignaciontablets`
  ADD PRIMARY KEY (`serial_tablets`),
  ADD KEY `cedula` (`cedula`,`serial_tablets`,`usuario`),
  ADD KEY `serial_tablets` (`serial_tablets`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacionteclado`
--
ALTER TABLE `asignacionteclado`
  ADD PRIMARY KEY (`serial_teclado`),
  ADD KEY `cedula` (`cedula`,`serial_teclado`,`usuario`),
  ADD KEY `serial_teclado` (`serial_teclado`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `asignacion_aplicacion`
--
ALTER TABLE `asignacion_aplicacion`
  ADD KEY `aplicacion` (`aplicacion`),
  ADD KEY `cedula` (`cedula`);

--
-- Indices de la tabla `camara`
--
ALTER TABLE `camara`
  ADD PRIMARY KEY (`serial_camara`),
  ADD KEY `estado_camara` (`estado_camara`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `cpu`
--
ALTER TABLE `cpu`
  ADD PRIMARY KEY (`serial_cpu`),
  ADD KEY `marca_cpu` (`marca_cpu`,`memoria`,`procesador`,`sistema_operativo`,`disco_duro`,`estado_cpu`),
  ADD KEY `memoria` (`memoria`),
  ADD KEY `procesador` (`procesador`),
  ADD KEY `sistema_operativo` (`sistema_operativo`),
  ADD KEY `disco_duro` (`disco_duro`),
  ADD KEY `estado_cpu` (`estado_cpu`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `disco_duro`
--
ALTER TABLE `disco_duro`
  ADD PRIMARY KEY (`id_discoduro`);

--
-- Indices de la tabla `equipo`
--
ALTER TABLE `equipo`
  ADD PRIMARY KEY (`id_equipo`);

--
-- Indices de la tabla `estado_equipo`
--
ALTER TABLE `estado_equipo`
  ADD PRIMARY KEY (`id_estadoequipo`);

--
-- Indices de la tabla `estado_persona`
--
ALTER TABLE `estado_persona`
  ADD PRIMARY KEY (`id_estadopersona`);

--
-- Indices de la tabla `historial_camara`
--
ALTER TABLE `historial_camara`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `serial_camara` (`serial_camara`),
  ADD KEY `serial_camara_2` (`serial_camara`),
  ADD KEY `serial_camara_3` (`serial_camara`),
  ADD KEY `serial_camara_4` (`serial_camara`),
  ADD KEY `serial_camara_5` (`serial_camara`);

--
-- Indices de la tabla `historial_cpu`
--
ALTER TABLE `historial_cpu`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `serial_cpu` (`serial_cpu`),
  ADD KEY `serial_cpu_2` (`serial_cpu`);

--
-- Indices de la tabla `historial_impresora`
--
ALTER TABLE `historial_impresora`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `serial_impresora` (`serial_impresora`),
  ADD KEY `serial_impresora_2` (`serial_impresora`),
  ADD KEY `serial_impresora_3` (`serial_impresora`);

--
-- Indices de la tabla `historial_mouse`
--
ALTER TABLE `historial_mouse`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `serial_mouse` (`serial_mouse`),
  ADD KEY `serial_mouse_2` (`serial_mouse`);

--
-- Indices de la tabla `historial_pantalla`
--
ALTER TABLE `historial_pantalla`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `serial_pantalla` (`serial_pantalla`),
  ADD KEY `serial_pantalla_2` (`serial_pantalla`);

--
-- Indices de la tabla `historial_portatil`
--
ALTER TABLE `historial_portatil`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `marca_portatil` (`marca_portatil`,`memoria`,`procesador`,`sistema_operativo`,`disco_duro`,`usuario`),
  ADD KEY `estado_portatil` (`estado_portatil`),
  ADD KEY `serial_portatil` (`serial_portatil`);

--
-- Indices de la tabla `historial_tablets`
--
ALTER TABLE `historial_tablets`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `serial_tablets` (`serial_tablets`),
  ADD KEY `serial_tablets_2` (`serial_tablets`),
  ADD KEY `serial_tablets_3` (`serial_tablets`);

--
-- Indices de la tabla `historial_teclado`
--
ALTER TABLE `historial_teclado`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `serial_teclado` (`serial_teclado`),
  ADD KEY `serial_teclado_2` (`serial_teclado`);

--
-- Indices de la tabla `impresoras`
--
ALTER TABLE `impresoras`
  ADD PRIMARY KEY (`serial_impresora`),
  ADD KEY `usuario` (`usuario`,`estado_impresora`),
  ADD KEY `estado_impresora` (`estado_impresora`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `marca_cpu`
--
ALTER TABLE `marca_cpu`
  ADD PRIMARY KEY (`id_marcacpu`);

--
-- Indices de la tabla `marca_pantalla`
--
ALTER TABLE `marca_pantalla`
  ADD PRIMARY KEY (`id_marcapantalla`);

--
-- Indices de la tabla `marca_portatil`
--
ALTER TABLE `marca_portatil`
  ADD PRIMARY KEY (`id_marcaportatil`);

--
-- Indices de la tabla `marca_tablets`
--
ALTER TABLE `marca_tablets`
  ADD PRIMARY KEY (`id_marcatablets`);

--
-- Indices de la tabla `memoria`
--
ALTER TABLE `memoria`
  ADD PRIMARY KEY (`id_memoria`);

--
-- Indices de la tabla `mouse`
--
ALTER TABLE `mouse`
  ADD PRIMARY KEY (`serial_mouse`),
  ADD KEY `estado_mouse` (`estado_mouse`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `pantalla`
--
ALTER TABLE `pantalla`
  ADD PRIMARY KEY (`serial_pantalla`),
  ADD KEY `marca_pantalla` (`marca_pantalla`,`estado_pantalla`),
  ADD KEY `estado_pantalla` (`estado_pantalla`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `portatil`
--
ALTER TABLE `portatil`
  ADD PRIMARY KEY (`serial_portatil`),
  ADD KEY `estado_portatil` (`estado_portatil`,`marca_portatil`,`memoria`,`procesador`,`sistema_operativo`,`disco_duro`,`usuario`),
  ADD KEY `marca_portatil` (`marca_portatil`),
  ADD KEY `procesador` (`procesador`),
  ADD KEY `disco_duro` (`disco_duro`),
  ADD KEY `memoria` (`memoria`),
  ADD KEY `sistema_operativo` (`sistema_operativo`),
  ADD KEY `usuario` (`usuario`);

--
-- Indices de la tabla `procesador`
--
ALTER TABLE `procesador`
  ADD PRIMARY KEY (`id_procesador`);

--
-- Indices de la tabla `registro_persona`
--
ALTER TABLE `registro_persona`
  ADD PRIMARY KEY (`cedula`),
  ADD KEY `sede` (`sede`,`area`,`estado_persona`),
  ADD KEY `area` (`area`),
  ADD KEY `estado_persona` (`estado_persona`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `rol`
--
ALTER TABLE `rol`
  ADD PRIMARY KEY (`id_rol`);

--
-- Indices de la tabla `sedes`
--
ALTER TABLE `sedes`
  ADD PRIMARY KEY (`id_sede`);

--
-- Indices de la tabla `sistema_operativo`
--
ALTER TABLE `sistema_operativo`
  ADD PRIMARY KEY (`id_sistemaoperativo`);

--
-- Indices de la tabla `tablets`
--
ALTER TABLE `tablets`
  ADD PRIMARY KEY (`serial_tablets`),
  ADD KEY `estado_tablets` (`estado_tablets`,`marca_tablets`,`procesador`,`sistema_operativo`,`memoria`,`usuario`),
  ADD KEY `marca_tablets` (`marca_tablets`),
  ADD KEY `procesador` (`procesador`),
  ADD KEY `sistema_operativo` (`sistema_operativo`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `teclado`
--
ALTER TABLE `teclado`
  ADD PRIMARY KEY (`serial_teclado`),
  ADD KEY `estado_teclado` (`estado_teclado`),
  ADD KEY `usuario` (`usuario`),
  ADD KEY `codigo` (`codigo`);

--
-- Indices de la tabla `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`usuario`);

--
-- AUTO_INCREMENT de las tablas volcadas
--

--
-- AUTO_INCREMENT de la tabla `areas`
--
ALTER TABLE `areas`
  MODIFY `id_area` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=13;
--
-- AUTO_INCREMENT de la tabla `asignacionequipos`
--
ALTER TABLE `asignacionequipos`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=23;
--
-- AUTO_INCREMENT de la tabla `camara`
--
ALTER TABLE `camara`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `cpu`
--
ALTER TABLE `cpu`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `disco_duro`
--
ALTER TABLE `disco_duro`
  MODIFY `id_discoduro` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=20;
--
-- AUTO_INCREMENT de la tabla `estado_equipo`
--
ALTER TABLE `estado_equipo`
  MODIFY `id_estadoequipo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT de la tabla `estado_persona`
--
ALTER TABLE `estado_persona`
  MODIFY `id_estadopersona` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `historial_camara`
--
ALTER TABLE `historial_camara`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=9;
--
-- AUTO_INCREMENT de la tabla `historial_cpu`
--
ALTER TABLE `historial_cpu`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=7;
--
-- AUTO_INCREMENT de la tabla `historial_impresora`
--
ALTER TABLE `historial_impresora`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT de la tabla `historial_mouse`
--
ALTER TABLE `historial_mouse`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `historial_pantalla`
--
ALTER TABLE `historial_pantalla`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT de la tabla `historial_portatil`
--
ALTER TABLE `historial_portatil`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT de la tabla `historial_tablets`
--
ALTER TABLE `historial_tablets`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `historial_teclado`
--
ALTER TABLE `historial_teclado`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `impresoras`
--
ALTER TABLE `impresoras`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `marca_cpu`
--
ALTER TABLE `marca_cpu`
  MODIFY `id_marcacpu` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT de la tabla `marca_pantalla`
--
ALTER TABLE `marca_pantalla`
  MODIFY `id_marcapantalla` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `marca_portatil`
--
ALTER TABLE `marca_portatil`
  MODIFY `id_marcaportatil` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `marca_tablets`
--
ALTER TABLE `marca_tablets`
  MODIFY `id_marcatablets` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=4;
--
-- AUTO_INCREMENT de la tabla `memoria`
--
ALTER TABLE `memoria`
  MODIFY `id_memoria` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=18;
--
-- AUTO_INCREMENT de la tabla `mouse`
--
ALTER TABLE `mouse`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT de la tabla `pantalla`
--
ALTER TABLE `pantalla`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT de la tabla `procesador`
--
ALTER TABLE `procesador`
  MODIFY `id_procesador` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `registro_persona`
--
ALTER TABLE `registro_persona`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=18;
--
-- AUTO_INCREMENT de la tabla `sedes`
--
ALTER TABLE `sedes`
  MODIFY `id_sede` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=33;
--
-- AUTO_INCREMENT de la tabla `sistema_operativo`
--
ALTER TABLE `sistema_operativo`
  MODIFY `id_sistemaoperativo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `tablets`
--
ALTER TABLE `tablets`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=6;
--
-- AUTO_INCREMENT de la tabla `teclado`
--
ALTER TABLE `teclado`
  MODIFY `codigo` int(3) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `aplicaciones`
--
ALTER TABLE `aplicaciones`
  ADD CONSTRAINT `aplicaciones_ibfk_1` FOREIGN KEY (`estado_aplicacion`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacioimpresora`
--
ALTER TABLE `asignacioimpresora`
  ADD CONSTRAINT `asignacioimpresora_ibfk_1` FOREIGN KEY (`serial_impresora`) REFERENCES `impresoras` (`serial_impresora`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `asignacioimpresora_ibfk_2` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacioncamara`
--
ALTER TABLE `asignacioncamara`
  ADD CONSTRAINT `asignacioncamara_ibfk_1` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`),
  ADD CONSTRAINT `asignacioncamara_ibfk_2` FOREIGN KEY (`serial_camara`) REFERENCES `camara` (`serial_camara`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacioncpu`
--
ALTER TABLE `asignacioncpu`
  ADD CONSTRAINT `asignacioncpu_ibfk_1` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`),
  ADD CONSTRAINT `asignacioncpu_ibfk_2` FOREIGN KEY (`serial_cpu`) REFERENCES `cpu` (`serial_cpu`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacionequipos`
--
ALTER TABLE `asignacionequipos`
  ADD CONSTRAINT `asignacionequipos_ibfk_1` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacionmouse`
--
ALTER TABLE `asignacionmouse`
  ADD CONSTRAINT `asignacionmouse_ibfk_1` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`),
  ADD CONSTRAINT `asignacionmouse_ibfk_2` FOREIGN KEY (`serial_mouse`) REFERENCES `mouse` (`serial_mouse`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacionpantalla`
--
ALTER TABLE `asignacionpantalla`
  ADD CONSTRAINT `asignacionpantalla_ibfk_2` FOREIGN KEY (`serial_pantalla`) REFERENCES `pantalla` (`serial_pantalla`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `asignacionpantalla_ibfk_4` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacionportatil`
--
ALTER TABLE `asignacionportatil`
  ADD CONSTRAINT `asignacionportatil_ibfk_1` FOREIGN KEY (`serial_portatil`) REFERENCES `portatil` (`serial_portatil`),
  ADD CONSTRAINT `asignacionportatil_ibfk_2` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignaciontablets`
--
ALTER TABLE `asignaciontablets`
  ADD CONSTRAINT `asignaciontablets_ibfk_1` FOREIGN KEY (`serial_tablets`) REFERENCES `tablets` (`serial_tablets`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `asignaciontablets_ibfk_2` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacionteclado`
--
ALTER TABLE `asignacionteclado`
  ADD CONSTRAINT `asignacionteclado_ibfk_1` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`),
  ADD CONSTRAINT `asignacionteclado_ibfk_2` FOREIGN KEY (`serial_teclado`) REFERENCES `teclado` (`serial_teclado`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `asignacion_aplicacion`
--
ALTER TABLE `asignacion_aplicacion`
  ADD CONSTRAINT `asignacion_aplicacion_ibfk_1` FOREIGN KEY (`aplicacion`) REFERENCES `aplicaciones` (`aplicacion`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `asignacion_aplicacion_ibfk_2` FOREIGN KEY (`cedula`) REFERENCES `registro_persona` (`cedula`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `camara`
--
ALTER TABLE `camara`
  ADD CONSTRAINT `camara_ibfk_2` FOREIGN KEY (`estado_camara`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `cpu`
--
ALTER TABLE `cpu`
  ADD CONSTRAINT `cpu_ibfk_3` FOREIGN KEY (`procesador`) REFERENCES `procesador` (`id_procesador`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `cpu_ibfk_4` FOREIGN KEY (`sistema_operativo`) REFERENCES `sistema_operativo` (`id_sistemaoperativo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `cpu_ibfk_5` FOREIGN KEY (`disco_duro`) REFERENCES `disco_duro` (`id_discoduro`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `cpu_ibfk_7` FOREIGN KEY (`estado_cpu`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `cpu_ibfk_8` FOREIGN KEY (`marca_cpu`) REFERENCES `marca_cpu` (`id_marcacpu`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_camara`
--
ALTER TABLE `historial_camara`
  ADD CONSTRAINT `historial_camara_ibfk_1` FOREIGN KEY (`serial_camara`) REFERENCES `camara` (`serial_camara`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_cpu`
--
ALTER TABLE `historial_cpu`
  ADD CONSTRAINT `historial_cpu_ibfk_1` FOREIGN KEY (`serial_cpu`) REFERENCES `cpu` (`serial_cpu`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_impresora`
--
ALTER TABLE `historial_impresora`
  ADD CONSTRAINT `historial_impresora_ibfk_1` FOREIGN KEY (`serial_impresora`) REFERENCES `impresoras` (`serial_impresora`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_mouse`
--
ALTER TABLE `historial_mouse`
  ADD CONSTRAINT `historial_mouse_ibfk_1` FOREIGN KEY (`serial_mouse`) REFERENCES `mouse` (`serial_mouse`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_pantalla`
--
ALTER TABLE `historial_pantalla`
  ADD CONSTRAINT `historial_pantalla_ibfk_1` FOREIGN KEY (`serial_pantalla`) REFERENCES `pantalla` (`serial_pantalla`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_portatil`
--
ALTER TABLE `historial_portatil`
  ADD CONSTRAINT `historial_portatil_ibfk_1` FOREIGN KEY (`serial_portatil`) REFERENCES `portatil` (`serial_portatil`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_tablets`
--
ALTER TABLE `historial_tablets`
  ADD CONSTRAINT `historial_tablets_ibfk_1` FOREIGN KEY (`serial_tablets`) REFERENCES `tablets` (`serial_tablets`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `historial_teclado`
--
ALTER TABLE `historial_teclado`
  ADD CONSTRAINT `historial_teclado_ibfk_1` FOREIGN KEY (`serial_teclado`) REFERENCES `teclado` (`serial_teclado`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `mouse`
--
ALTER TABLE `mouse`
  ADD CONSTRAINT `mouse_ibfk_1` FOREIGN KEY (`estado_mouse`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `pantalla`
--
ALTER TABLE `pantalla`
  ADD CONSTRAINT `pantalla_ibfk_1` FOREIGN KEY (`marca_pantalla`) REFERENCES `marca_pantalla` (`id_marcapantalla`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `pantalla_ibfk_2` FOREIGN KEY (`estado_pantalla`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `portatil`
--
ALTER TABLE `portatil`
  ADD CONSTRAINT `portatil_ibfk_2` FOREIGN KEY (`marca_portatil`) REFERENCES `marca_portatil` (`id_marcaportatil`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `portatil_ibfk_3` FOREIGN KEY (`procesador`) REFERENCES `procesador` (`id_procesador`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `portatil_ibfk_4` FOREIGN KEY (`disco_duro`) REFERENCES `disco_duro` (`id_discoduro`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `portatil_ibfk_5` FOREIGN KEY (`memoria`) REFERENCES `memoria` (`id_memoria`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `portatil_ibfk_6` FOREIGN KEY (`sistema_operativo`) REFERENCES `sistema_operativo` (`id_sistemaoperativo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `portatil_ibfk_8` FOREIGN KEY (`estado_portatil`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `registro_persona`
--
ALTER TABLE `registro_persona`
  ADD CONSTRAINT `registro_persona_ibfk_1` FOREIGN KEY (`area`) REFERENCES `areas` (`id_area`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `registro_persona_ibfk_3` FOREIGN KEY (`estado_persona`) REFERENCES `estado_persona` (`id_estadopersona`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `registro_persona_ibfk_5` FOREIGN KEY (`sede`) REFERENCES `sedes` (`id_sede`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `tablets`
--
ALTER TABLE `tablets`
  ADD CONSTRAINT `tablets_ibfk_1` FOREIGN KEY (`marca_tablets`) REFERENCES `marca_tablets` (`id_marcatablets`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tablets_ibfk_2` FOREIGN KEY (`procesador`) REFERENCES `procesador` (`id_procesador`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tablets_ibfk_3` FOREIGN KEY (`sistema_operativo`) REFERENCES `sistema_operativo` (`id_sistemaoperativo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tablets_ibfk_4` FOREIGN KEY (`estado_tablets`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Filtros para la tabla `teclado`
--
ALTER TABLE `teclado`
  ADD CONSTRAINT `teclado_ibfk_1` FOREIGN KEY (`estado_teclado`) REFERENCES `estado_equipo` (`id_estadoequipo`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
